let carteVecteur;
let marqueurVecteur;
let visionneuse;
const pnxApi = 'https://api.panoramax.xyz/api/';
const pays = 'PT';
$(function() {
  let cserveur = 'https://tuile.mapaedifi.eu/';
  fetch(cserveur + pays.toLowerCase() + ".json")
    .then(response => response.json())
    .then(data => {
      let styleURL = window.location.protocol + '//' + window.location.host + '/xref/' + pays + '/style.json';
      let bounds = data.bounds;
      carteVecteur = new maplibregl.Map({
        container: 'carte-conteneur',
        style: styleURL,
        attributionControl: {
        compact: false,
          customAttribution:
            'Style © <a href="https://openmaptiles.org/">OpenMapTiles</a>, ' +
            '<a href="https://github.com/gravitystorm/openstreetmap-carto">OSM Carto</a> | ' +
            'Données © <a href="https://www.openstreetmap.org/copyright">Contributrices•teurs OpenStreetMap</a> | ' +
            '<a href="https://maplibre.org/">MapLibre</a>'
          },
          center: [(Number(bounds[0])+Number(bounds[2]))/2,
                   (Number(bounds[1])+Number(bounds[3]))/2],
          zoom: 9,
          minZoom: 0,
          maxZoom: 18
      });
      carteVecteur.addControl(new maplibregl.NavigationControl());
    });
  $('.cartographie').on('click', function() {
    carteVecteur.setCenter([this.dataset.lon, this.dataset.lat]).setZoom(16);
    if (marqueurVecteur === undefined) {
      marqueurVecteur = new maplibregl.Marker().setLngLat([this.dataset.lon, this.dataset.lat]).addTo(carteVecteur);
    } else {
      marqueurVecteur.setLngLat([this.dataset.lon, this.dataset.lat]);
    }
    document.getElementById('carte-popup').showModal();
  });
  $('.panoramax').on('click', function() {
    if (this.dataset.hasOwnProperty('id')) {
      const idPnx = this.dataset.id;
      $.get(
        pnxApi + 'search?ids=' + idPnx
      ).done(function(data) {
        let liste = data.features;
        if (liste.length === 0) {
          alert("Photo Panoramax non trouvée");
        } else {
          if (typeof visionneuse === 'undefined') {
          creerVisionneuse();
          }
          document.getElementById('panoramax').showModal();
          visionneuse.select(liste[0].collection, liste[0].id);
        }
      }).fail(function(jqxhr, txtStatus) {
        console.log("Erreur Panoramax");
      });
    } else {
      const bouton = $(this).closest('td').find('.cartographie');
      const lat = Number.parseFloat(bouton.get(0).dataset.lat);
      const lon = Number.parseFloat(bouton.get(0).dataset.lon);
      const fenetre = [lon - 0.005, lat - 0.0005, lon + 0.005, lat + 0.0005];
      $.get(
        pnxApi + 'search?bbox=' + fenetre.toString()
      ).done(function(data) {
        let liste = data.features;
        if (liste.length === 0) {
          document.getElementById('contribution').showModal();
        } else {
          if (typeof visionneuse === 'undefined') {
           creerVisionneuse();
          }
          document.getElementById('panoramax').showModal();
          visionneuse.select(liste[0].collection, liste[0].id);
        }
      }).fail(function(jqxhr, txtStatus) {
        console.log("Erreur Panoramax");
      });
    }
  });
  $('#fermer-carte').on('click', function() {
    document.getElementById('carte-popup').close();
  });
  $('#fermer-contribution').on('click', function() {
    document.getElementById('contribution').close();
  });
});

function creerVisionneuse() {
  visionneuse = document.createElement('pnx-viewer');
  visionneuse.endpoint = pnxApi;
  const widgetPnx = document.createElement('p');
  widgetPnx.slot = 'bottom-right';
  const an = document.createElement('a');
  an.href = 'https://panoramax.fr/';
  let im = document.createElement('img');
  im.src = 'images/panoramax48.png';
  im.alt = "Panoramax";
  im.width = 48;
  im.height = 48;
  an.appendChild(im);
  widgetPnx.appendChild(an);
  visionneuse.appendChild(widgetPnx);
  const widgetFermer = document.createElement('p');
  widgetFermer.slot = 'top-right';
  im = document.createElement('img');
  im.src = 'images/cancel.png';
  im.alt = "Fermer";
  im.width = 32;
  im.height = 32;
  im.id = 'fermer-panoramax';
  widgetFermer.appendChild(im);
  widgetFermer.addEventListener('click', function() {
    document.getElementById('panoramax').close();
  });
  visionneuse.appendChild(widgetFermer);
  $('#panoramax').prepend(visionneuse);
}
